#version 450 compatibility

layout (local_size_x = 8, local_size_y = 8) in;
const vec2 workGroupsRender = vec2(1.0f, 1.0f);

layout (rgba16f) uniform image2D colorimg2;

#define gl_FragCoord gl_GlobalInvocationID

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Material.inc"

#include "/lib/Head/Functions.inc"

#include "/lib/Surface/ReflectionFilter.glsl"

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	//#if !defined MC_SPECULAR_MAP
	//	if (wetnessCustom < 5e-3) return;
	//#endif

	ivec2 texel = ivec2(gl_FragCoord.xy);
    vec4 reflectionData = imageLoad(colorimg2, texel);

	Material material = GetMaterialData(texelFetch(colortex0, texel, 0).xy);

    if (material.hasReflections && reflectionData.a > 1e-3 && material.isRough) {
		vec3 normal = GetNormals(texel);
		vec3 viewDir = normalize(ScreenToViewSpace(vec3(texel * screenPixelSize, GetDepthT(texel))));
		reflectionData = ReflectionFilter(texel, reflectionData, material.roughness, normal, viewDir, 2.0, vec2(0.0));
	}

    imageStore(colorimg2, texel, reflectionData);
}
