#version 450 compatibility


out vec2 texcoord;

flat out vec3 colorSunlight;
//out vec3 colorMistlight;
flat out vec3 colorSkylight;
flat out vec3 colorTorchlight;

flat out vec4 skySHR;
flat out vec4 skySHG;
flat out vec4 skySHB;


#include "/lib/Head/Common.inc"

uniform sampler2D colortex5;

uniform float nightVision;
uniform float wetness;
uniform float isLightningFlashing;

uniform vec3 worldSunVector;
uniform vec3 worldLightVector;

uniform int moonPhase;

uniform vec2 screenPixelSize;
uniform vec2 screenSize;

#include "/lib/Atmosphere/Atmosphere.glsl"

/*
void GetSkylightData(out vec4 skySHR, out vec4 skySHG, out vec4 skySHB
	//, out vec3 colorSkylight, out vec3 colorSkyUp
) {
	//colorSkylight = vec3(0.0);

	skySHR = vec4(0.0);
	skySHG = vec4(0.0);
	skySHB = vec4(0.0);

	//float tileSize = floor(min(viewWidth * rcp(3.0), viewHeight * 0.5)) * 0.25;
	for (uint i = 0u; i < 5u; ++i) {
		float latitude = float(i) * 0.62831853;
		float cosLatitude = cos(latitude), sinLatitude = sin(latitude);
		for (uint j = 0u; j < 5u; ++j) {
			float longitude = float(j) * 1.25663706;
			vec3 rayDir = vec3(cosLatitude * cos(longitude), sinLatitude, cosLatitude * sin(longitude));

			vec3 skyCol = texture(colortex5, ProjectSky(rayDir)).rgb;
			//colorSkylight += skyCol;

			skySHR += ToSH(skyCol.r, rayDir);
			skySHG += ToSH(skyCol.g, rayDir);
			skySHB += ToSH(skyCol.b, rayDir);
		}
	}

	skySHR /= 25.0;
	skySHG /= 25.0;
	skySHB /= 25.0;

	//colorSkylight /= 25.0;
	//colorSkyUp = SkyShading(vec3(0.0, 1.0, 0.0), worldSunVector);
}
*/
void main() {
	gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
	texcoord = gl_MultiTexCoord0.xy;

	//colorSunlight = GetColorSunlight(worldSunVector);
	colorSunlight = texelFetch(colortex5, ivec2(screenSize * 0.2 + 1), 0).rgb;
	//colorMistlight = CumulusSunlightColor();

	//GetSkylightData(skySHR, skySHG, skySHB
		//, colorSkylight
	//);

	skySHR = vec4(0.0);
	skySHG = vec4(0.0);
	skySHB = vec4(0.0);

	//float tileSize = floor(min(viewWidth * rcp(3.0), viewHeight * 0.5)) * 0.25;
	for (uint i = 0u; i < 5u; ++i) {
		float latitude = float(i) * 0.62831853;
		float cosLatitude = cos(latitude), sinLatitude = sin(latitude);
		for (uint j = 0u; j < 5u; ++j) {
			float longitude = float(j) * 1.25663706;
			vec3 rayDir = vec3(cosLatitude * cos(longitude), sinLatitude, cosLatitude * sin(longitude));

			vec3 skyCol = SkyShading(rayDir);
			// vec3 skyCol = texture(colortex5, ProjectSky(rayDir)).rgb;
			//colorSkylight += skyCol;

			skySHR += ToSH(skyCol.r, rayDir);
			skySHG += ToSH(skyCol.g, rayDir);
			skySHB += ToSH(skyCol.b, rayDir);
		}
	}

	skySHR /= 25.0;
	skySHG /= 25.0;
	skySHB /= 25.0;


	colorSkylight = texelFetch(colortex5, ivec2(screenSize * 0.2 + 2), 0).rgb;

	colorTorchlight = Blackbody(float(TORCHLIGHT_COLOR_TEMPERATURE));
}
