#version 450 compatibility

out vec3 sceneData;

in vec2 texcoord;

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Functions.inc"

#include "/lib/Head/Mask.inc"

#include "/lib/Water/WaterFog.glsl"

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	ivec2 texel = ivec2(gl_FragCoord.xy);

	int materialIDT = int(texelFetch(colortex7, texel, 0).z * 255.0);
	TranslucentMask materialMaskT = CalculateMasksT(materialIDT);

	sceneData = texelFetch(colortex4, texel, 0).rgb;
	if ((materialMaskT.water || materialMaskT.ice) && isEyeInWater == 0) {
		vec3 viewPos = ScreenToViewSpace(vec3(texcoord, GetDepthT(texel)));
		vec3 viewPos1 = ScreenToViewSpace(vec3(texcoord, GetDepth(texel)));
		WaterFog(sceneData, materialMaskT, 0.0, 0.0, distance(viewPos, viewPos1));
	}
}

/* DRAWBUFFERS:4 */
