
out vec3 color;

/* DRAWBUFFERS:2 */

uniform sampler2D colortex2;
uniform sampler2D colortex5;

uniform vec2 screenSize;

uniform float frameTime;

in vec2 texcoord;

#include "/lib/Head/Common.inc"

float InterleavedGradientNoise(in vec2 coord) {
    return fract(52.9829189 * fract(0.06711056 * coord.x + 0.00583715 * coord.y));
}

vec3 MotionBlur() {
	vec2 velocity = texture(colortex2, texcoord).xy;

	if (length(velocity) < 1e-7) return texture(colortex5, texcoord).rgb;

    //velocity = clamp(velocity * 0.1, -0.28, 0.28);
	velocity *= MOTION_BLUR_STRENGTH / float(MOTION_BLUR_SAMPLES) * min(rcp(frameTime * 30.0), 2.0);

	float dither = InterleavedGradientNoise(gl_FragCoord.xy);

    vec2 sampleCoord = texcoord + velocity * dither;
	sampleCoord -= velocity * MOTION_BLUR_SAMPLES * 0.5;

	vec3 color = vec3(0.0);
    uint weight = 0u;

	for (uint i = 0u; i < MOTION_BLUR_SAMPLES; ++i, sampleCoord += velocity) {
		++weight;
		if (saturate(sampleCoord) == sampleCoord) {
			color += texelFetch(colortex5, ivec2(sampleCoord * screenSize), 0).rgb;
            break;
        }

        color += texelFetch(colortex5, ivec2(clamp(sampleCoord * screenSize, vec2(2.0), screenSize - 2.0)), 0).rgb;
	}

	return clamp16F(color * rcp(weight));
}

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	#ifdef MOTION_BLUR
	#endif
	color = MotionBlur();
}
