
float textureSmoothFilter(in vec2 coord) {
	coord *= 256.0;
	coord += 0.5f;

	vec2 whole = floor(coord);
	vec2 part  = curve(coord - whole);

	coord = whole + part - 0.5f;
	coord /= 256.0;

	return texture(noisetex, coord).y;
}

float AlmostIdentity(in float x) {
	if (x > 0.2) return x;
	return x * x * 2.5 + 0.1;
}

float GetWaves(in vec3 position) {
    float wavesTime = frameTimeCounter * WATER_WAVE_SPEED;

    vec2 p = position.xz * 0.025;
    p -= position.y * 0.025;
    p.x = -p.x;

    p.x += wavesTime * 0.00625;
    p.y -= wavesTime * 0.00625;

    float allwaves = 0.0;
    float wave = textureSmoothFilter((p * vec2(2.0, 1.2f)) + vec2(0.0,  p.x * 2.1f));	p /= 2.1f;	p.y -= wavesTime / 80.0; p.x -= wavesTime / 120.0;
    allwaves += wave * 0.5;

    wave = textureSmoothFilter(p * vec2(2.0, 1.4f)  + vec2(0.0, -p.x * 2.1f));	p /= 1.5f;	p.x += wavesTime / 80.0;
    wave *= 2.1f;
    allwaves += wave;

    wave = textureSmoothFilter(p * vec2(1.0, 0.75f) + vec2(0.0,  p.x * 1.1f));	p /= 1.5f;	p.x -= wavesTime / 220.0;
    wave *= 17.25f;
    allwaves += wave;

    wave = textureSmoothFilter(p * vec2(1.0, 0.75f) + vec2(0.0, -p.x * 1.7f));	p /= 1.9f;	p.x += wavesTime / 620.0;
    wave *= 15.25f;
    allwaves += wave;

    wave = abs(textureSmoothFilter(p * vec2(1.0, 0.8f) + vec2(0.0, -p.x * 1.7f)) * 2.0 - 1.0);	p /= 2.0; p.x += wavesTime / 620.0;
    wave = 1.0 - AlmostIdentity(wave);
    wave *= 29.25f;
    allwaves += wave;

    wave = abs(textureSmoothFilter(p * vec2(1.0, 0.8f) + vec2(0.0,  p.x * 1.7f)) * 2.0 - 1.0);
    wave = 1.0 - AlmostIdentity(wave);
    wave *= 15.25f;
    allwaves += wave;

    allwaves /= 80.1;
    allwaves /= 1.0 + dot(fwidth(position), vec3(0.7));

    return allwaves;
}

vec3 GetWavesNormal(in vec3 position) {
	const float waveHeight = 8.0 * WATER_WAVE_HEIGHT;
	position.xz -= 0.02f;

	float wavesCenter = GetWaves(position);
	float wavesLeft = GetWaves(position + vec3(0.04f, 0.0, 0.0));
	float wavesUp   = GetWaves(position + vec3(0.0, 0.0, 0.04f));

	vec2 wavesNormal = vec2(wavesCenter - wavesLeft, wavesCenter - wavesUp);
	wavesNormal *= waveHeight;

	return normalize(vec3(wavesNormal, 1.0));
}
