/*
vec4 ReflectionFilter(in ivec2 texel, in vec4 reflectionData, in float smoothness, in vec3 normal, in float size, in float noise) {
    float roughness = sqr(1.0 - smoothness);

    vec4 accum = vec4(0.0);
    float sumWeight = 0.0;

    vec2 coordOffset = vec2(12.0 * size * min(roughness * 20.0, 1.0) * (1.0 - expf(-sqrt(reflectionData.a) * 50.0)));

    coordOffset *= noise + 0.5;

    float roughnessInv = 1e2 / max(roughness, 1e-5);

    const ivec2 sampleOffset[8] = ivec2[8](
        vec2(-1,-1),
        vec2(-1, 0),
        vec2(-1, 1),
        vec2( 0,-1),
        vec2( 0, 1),
        vec2( 1,-1),
        vec2( 1, 0),
        vec2( 1, 1)
    );

    for (int i = 0; i < 8; i++) {
        ivec2 sampleTexel = ivec2(clamp(texel + sampleOffset[i] * coordOffset, ivec2(1), screenSize - 1));

        vec4 sampleData = texelFetch(colortex2, sampleTexel, 0);
        vec4 gbuffer3 = texelFetch(colortex3, ivec2(gl_FragCoord.xy), 0);

        float sampleRoughness = sqr(1.0 - UnpackUnorm2x8(gbuffer3.r).r);

        float normalWeight = pow(max(dot(normal, GetNormals(sampleTexel)), 1e-6), roughnessInv);
        float roughnessWeight = pow(1.0 - abs(roughness - sampleRoughness), 1e2);
        float weight = normalWeight * roughnessWeight * expf(-abs(reflectionData.a - sampleData.a) * smoothness) * step(2.5e-3, sampleRoughness);
        weight = saturate(weight);

        accum += sampleData * weight;
        sumWeight += weight;
    }
    if (sumWeight < 1e-3) return reflectionData;

    return accum / sumWeight;
}
*/
vec4 ReflectionFilter(in ivec2 texel, in vec4 reflectionData, in float roughness, in vec3 normal, in vec3 viewDir, in float size, in vec2 noise) {
    float NdotV = saturate(dot(-viewDir, normal));
    float linearDepth = GetDepthLinear(texel);

    float Temp = size * 22.0 * min(roughness * 20.0, 1.0);
    Temp *= reflectionData.w * 0.8 + 0.2;

    vec4 accum = vec4(0.0);
    float sumWeight = 0.0;

    float J = reflectionData.w * 0.475 + 0.025;

    const float cos17508 = cos(1.5708);
    const float sin15708 = sin(1.5708);
    vec2 D = normalize(cross(normal, viewDir).xy);
    vec2 L = D * mat2(cos17508, -sin15708, sin15708, cos17508);
    D *= mix(0.1075, 0.5, NdotV) * Temp;
    L *= mix(0.7, 0.5, NdotV) * Temp;

    //vec3 nVrN = reflect(-viewDir, normal);

    float roughnessInv = 1e2 / max(roughness, 1e-5);

    for (int i = -1; i <= 1; i++) {
        vec2 offsetPart1 = D * (i + noise.x) + texel;

        for (int j = -1; j <= 1; j++) {
            ivec2 sampleCoord = ivec2(offsetPart1 + L * (j + noise.y));
            sampleCoord = clamp(sampleCoord, ivec2(3), ivec2(screenSize - 3));

            vec4 sampleData = texelFetch(colortex2, sampleCoord, 0);

            if (sampleData.w < 1e-4) continue;

            //vec3 nVrSN = reflect(-viewDir, GetNormals(sampleCoord));
            float sampleLinerDepth = GetDepthLinear(sampleCoord);

            //float normalWeight = pow(saturate(dot(nVrN, nVrSN)), roughnessInv);
            float normalWeight = pow(max(dot(normal, GetNormals(sampleCoord)), 1e-6), roughnessInv);
            float depthWeight = expf(-(abs(sampleLinerDepth - linearDepth) * 1.1));
            float sampleWeight = normalWeight * depthWeight;

            accum += vec4(pow(length(sampleData.xyz), J) * normalize(sampleData.xyz + 1e-10), sampleData.w) * sampleWeight;
            sumWeight += sampleWeight;
        }
    }
    
    if (sumWeight < 1e-3) return reflectionData;

    accum /= sumWeight + 1e-4;
    accum.xyz = pow(length(accum.xyz), rcp(J)) * normalize(accum.xyz + 1e-06);

    //return clamp16F(accum);
    return clamp(accum, 0.0, 2e2);
}