
vec2 GetRainAnimationTex(in sampler2D tex, in vec2 uv, in float wet) {
	vec2 coord = vec2(uv.x, (uv.y - floor(fract(frameTimeCounter) * 60.0)) * rcp(60.0));

	vec2 n = texture(tex, coord).rg * vec2(2.0, -2.0) + vec2(-1.0, 1.0);

	return pow(abs(n), vec2(2.0 - cube(wet) * 1.2)) * sign(n);
}
/*
vec2 BilateralRainTex(in sampler2D tex, in vec2 uv, in float wet) {
	vec2 n = GetRainAnimationTex(tex, uv.xy, wet);
	vec2 nR = GetRainAnimationTex(tex, uv.xy + vec2(exp2(-7.0), 0.0), wet);
	vec2 nU = GetRainAnimationTex(tex, uv.xy + vec2(0.0, exp2(-7.0)), wet);
	vec2 nUR = GetRainAnimationTex(tex, uv.xy + vec2(exp2(-7.0)), wet);

	vec2 fractCoord = fract(uv.xy * 128.0);

	vec2 lerpX = mix(n, nR, fractCoord.x);
	vec2 lerpX2 = mix(nU, nUR, fractCoord.x);
	vec2 lerpY = mix(lerpX, lerpX2, fractCoord.y);

	return lerpY;
}
*/
vec2 GetRainNormal(in float wet, in vec3 position) {
	position *= 0.5;

	#ifdef RAIN_SPLASH_BILATERAL
		vec2 n = BilateralRainTex(colortex7, position.xz, wet);
	#else
		vec2 n = GetRainAnimationTex(colortex7, position.xz, wet);
	#endif

	position.xz -= vec2(frameTimeCounter, 0.6 * frameTimeCounter);
	//float downfall = texture(noisetex, position.xz * 0.0007).x;
	//downfall = saturate(downfall * 1.5 - 0.25);

	//wet = saturate(mix(wet, downfall, wetnessCustom * 0.3));

	//n *= 0.4;

	float lod = dot(abs(fwidth(position)), vec3(20.0));
	n /= 1.0 + lod;

	return n * wet;
}
/*
vec2 Get3DNoise(in vec3 position)
{
	vec3 p = floor(position);
	vec3 f = curve(position - p);

	vec2 uv =  p.xy + p.z * vec2(-97.0) + f.xy;
	vec2 uv2 = uv - 97.0;
	vec2 coord =  (uv  + 0.5f) * rcp(256.0);
	vec2 coord2 = (uv2 + 0.5f) * rcp(256.0);
	vec2 xy1 = texture(noisetex, coord).xy;
	vec2 xy2 = texture(noisetex, coord2).xy;
	return mix(xy1, xy2, f.z);
}
*/
float GetRainWetness(in vec2 position) {
	//vec3 p = position * vec3(0.7f, 0.2f, 0.7f);
	position -= frameTimeCounter * vec2(0.01, 0.006);
	position *= 0.007;

	//float n = Get3DNoise(p).y;
	//n += Get3DNoise(p * 0.5f).x * 2.0;
	//n += Get3DNoise(p * 0.25f).x * 4.0;
	float n = texture(noisetex, position).x;
	n += texture(noisetex, position * 0.5).y * 2.0;
	n += texture(noisetex, position * 0.2).x * 3.0;

	return saturate(n * 0.18 * wetnessCustom);
}
