/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.EntryInfo;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ButtonEntry
extends ContainerObjectSelectionList.Entry<ButtonEntry> {
    private static final Font textRenderer = Minecraft.m_91087_().f_91062_;
    public final Component text;
    public final List<AbstractWidget> buttons;
    public final EntryInfo info;
    public boolean centered = false;
    public MultiLineTextWidget title;

    public ButtonEntry(List<AbstractWidget> buttons, Component text, EntryInfo info) {
        this.buttons = buttons;
        this.text = text;
        this.info = info;
        if (info != null && info.comment != null) {
            this.centered = info.comment.centered();
        }
        int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        if (!(text == null || text.getString().contains("spacer") && buttons.isEmpty())) {
            this.title = new MultiLineTextWidget(12, 0, (Component)text.m_6881_(), textRenderer).m_269484_(this.centered);
            if (info != null) {
                this.title.m_257544_(info.getTooltip(false));
            }
            this.title.m_269098_(!buttons.isEmpty() ? buttons.get(buttons.size() > 2 ? buttons.size() - 1 : 0).m_252754_() - 16 : scaledWidth - 24);
            if (this.centered) {
                this.title.m_252865_(scaledWidth / 2 - this.title.m_5711_() / 2);
            }
        }
    }

    public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.buttons.forEach(b -> {
            b.m_253211_(y);
            b.m_88315_(context, mouseX, mouseY, tickDelta);
        });
        if (this.title != null) {
            this.title.m_253211_(y + 5);
            this.title.m_88315_(context, mouseX, mouseY, tickDelta);
            if (this.info.entry != null && !this.buttons.isEmpty()) {
                Optional.ofNullable(this.buttons.get(0)).ifPresent(widget -> {
                    int idMode = this.info.entry.idMode();
                    if (idMode != -1) {
                        context.m_280480_(idMode == 0 ? ((Item)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)this.info.tempValue))).m_7968_() : ((Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)this.info.tempValue))).m_5456_().m_7968_(), widget.m_252754_() + widget.m_5711_() - 18, y + 2);
                    }
                });
            }
        }
    }

    public boolean m_6375_(double d, double e, int i) {
        if (this.info != null && this.info.comment != null && !this.info.comment.url().isBlank()) {
            ConfirmLinkScreen.m_274480_((String)this.info.comment.url(), (Screen)Minecraft.m_91087_().f_91080_, (boolean)true);
        }
        return super.m_6375_(d, e, i);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Lists.newArrayList(this.buttons);
    }

    public List<? extends NarratableEntry> m_142437_() {
        return Lists.newArrayList(this.buttons);
    }
}

