/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.flat;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import me.jellysquid.mods.sodium.client.model.light.data.QuadLightData;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class FlatLightPipeline
implements LightPipeline {
    private final LightDataAccess lightCache;
    private final boolean useQuadNormalsForShading;

    public FlatLightPipeline(LightDataAccess lightCache) {
        this.lightCache = lightCache;
        this.useQuadNormalsForShading = SodiumClientMod.options().quality.useQuadNormalsForShading;
    }

    @Override
    public void calculate(ModelQuadView quad, BlockPos pos, QuadLightData out, Direction cullFace, Direction lightFace, boolean shade) {
        int flags;
        int lightmap = cullFace != null ? this.getOffsetLightmap(pos, cullFace) : (((flags = quad.getFlags()) & 4) != 0 || (flags & 2) != 0 && LightDataAccess.unpackFC(this.lightCache.get(pos)) ? this.getOffsetLightmap(pos, lightFace) : LightDataAccess.getEmissiveLightmap(this.lightCache.get(pos)));
        Arrays.fill(out.lm, lightmap);
        if ((quad.getFlags() & 8) != 0 || !this.useQuadNormalsForShading) {
            Arrays.fill(out.br, this.lightCache.getWorld().m_7717_(lightFace, shade));
        } else {
            this.applySidedBrightnessFromNormals(quad, out, shade);
        }
    }

    private void applySidedBrightnessFromNormals(ModelQuadView quad, QuadLightData out, boolean shade) {
        int normal = quad.getModFaceNormal();
        Arrays.fill(out.br, this.lightCache.getWorld().getShade(NormI8.unpackX(normal), NormI8.unpackY(normal), NormI8.unpackZ(normal), shade));
    }

    private int getOffsetLightmap(BlockPos pos, Direction face) {
        int word = this.lightCache.get(pos);
        if (LightDataAccess.unpackEM(word)) {
            return 0xF000F0;
        }
        int adjWord = this.lightCache.get(pos, face);
        return LightTexture.m_109885_((int)Math.max(LightDataAccess.unpackBL(adjWord), LightDataAccess.unpackLU(word)), (int)LightDataAccess.unpackSL(adjWord));
    }
}

